<?php
define('alterego_FUNCTIONS', TEMPLATEPATH . '/functions/');
define('alterego_THEME', get_template_directory_uri());
define('alterego_JAVASCRIPT', get_template_directory_uri() . '/js');
define('alterego_CSS', get_template_directory_uri() . '/css');

function optiontree_check(){

	$absolute_path = __FILE__;
	$path_to_file = explode( 'wp-content', $absolute_path );
	$path_to_wp = $path_to_file[0];
	require_once($path_to_wp . 'wp-admin/includes/plugin.php');

	if (is_plugin_active('option-tree/index.php')) {
		add_thickbox();
		add_action('admin_notices', 'optiontree_check_notice');
	}
	else{
		require_once (TEMPLATEPATH . '/functions/option-tree/index.php');
	}
}

function optiontree_check_notice(){
?>
  <div class='updated fade'>
    <p>Please <strong>deactivate</strong> the <strong>OptionTree plugin</strong> for the best AlterEgo backend solution.</p>
  </div>
<?php
}

optiontree_check();

/* Admin Functionality */
if (is_admin()){
	require_once(alterego_FUNCTIONS . '/theme_activation.php');
	require_once(alterego_FUNCTIONS . '/alterego_slider_admin/alterego_admin.php');
	require_once(alterego_FUNCTIONS . '/page_options/theme_page_options.php');
	require_once(alterego_FUNCTIONS . '/theme_sidebars_functions.php');
	require_once(alterego_FUNCTIONS . '/theme_portfolio_functions.php');
	require_once(alterego_FUNCTIONS . '/theme_featured_image_preview.php');
	require_once(alterego_FUNCTIONS . '/zilla-shortcodes/zilla-shortcodes.php');
	require_once(alterego_FUNCTIONS . '/theme_styles.php');
}

/* JavaScripts, Widgets, Sidebars, Shortcodes */
require_once(alterego_FUNCTIONS . '/theme_functions.php');
require_once(alterego_FUNCTIONS . '/theme_submenu.php');
require_once(alterego_FUNCTIONS . '/theme_javascriptcss.php');
require_once(alterego_FUNCTIONS . '/theme_widgets.php');
require_once(alterego_FUNCTIONS . '/theme_sidebars.php');
require_once(alterego_FUNCTIONS . '/theme_shortcodes.php');
require_once(alterego_FUNCTIONS . '/theme_shortcodes_special.php');
require_once(alterego_FUNCTIONS . '/theme_post_customtypes.php');
require_once(alterego_FUNCTIONS . '/theme_pagination.php');
require_once(alterego_FUNCTIONS . '/theme_post_comments.php');

/* Theme Language */
require_once(alterego_FUNCTIONS . '/theme_language.php');
?>